// Operating System : Windows XP or later, 
// Scilab           : 5.3.3 

//To find density(pdf) and distribution(cdf) function of a function of random variable 
//Y = 2X + 1(having form Y = aX + b). where X is gaussian R.V.

clc;
clear all;
clf();
mean_x = 1;//mean value of gaussian data
sd_x = 1;//standard deviation
vari_x = sd_x.^2;
lgd = [];
//PDF and CDF of Gaussian Random Variable X 
x = linspace(-10,10,100);
plot2d(x,((1/(sqrt(2*%pi*vari_x)))*exp(-0.5*(x-mean_x).^2/vari_x)),2);//plots pdf of X 
set(gca(),"auto_clear","off")
plot2d(x,cdfnor("PQ",x,mean_x*ones(x),sd_x*ones(x)),3);//cdf of gaussian RV X
set(gca(),"auto_clear","on")
xlabel('sample points');
ylabel('PDF & CDF');
//title('density and distribution function for Gaussian function');
legend(['PDF of normal distribution';'CDF of normal distribution'],2);

//PDF and CDF of Y = aX + b where a = 2, b = 1
a = 2;
b = 1;
y = a*x+b;//Function of One Random Variable
mean_y=a*mean_x+b;
vari_y=(a*sd_x).^2;
figure(2,"BackgroundColor",[1,1,1]);
plot2d(y,((1/(sqrt(2*%pi*vari_y*a.^2)))*exp(-0.5*(y-mean_y).^2/vari_y)),2);//pdf of Y 
set(gca(),"auto_clear","off")
plot2d(x,cdfnor("PQ",y,(a*mean_x+b)*ones(x),(a*sd_x)*ones(x)),3);//cdf of y
set(gca(),"auto_clear","on")
xlabel('sample points');
ylabel('PDF & CDF of Y = 2X + 1');
legend(['PDF of Y = 2X + 1';'CDF of Y = 2X + 1'],2);


//Assignment :
//1. Perform the operation for function Y = 5X + 1.
//2. Generate pdf and cdf of nonlinear function between Y and X.
